% Read EXCEL input: share; eps_target; eps_calib; eta_target; eta_calib
data = xlsread('.\input\elastheta.xlsx','16x16','B3:F18');

% Declare dimension
n = 16;

% Check Engel's aggregation (variable engel = 1 must hold)
eta_target = data(1:n, 4:4);
theta = data(1:n, 1:1);
engel = theta'*eta_target;

% Create a diagonal matrix with diagonal terms being the own-price AUES elasticities
eps_target = data(1:n, 2:2);
theta_diag = diag(theta);
aues_diag = diag(inv(theta_diag)*eps_target);

% Initialize the determinants for checking ND (sa stores values of various
% determinants)
sa = zeros(n,1);
for i = 1:n-1
    sa(i) = (-1)^(i+1);
end

%while sa(i)*(-1)^(i+1)>0
while sa(1)>0|sa(2)<0|sa(3)>0|sa(4)<0|sa(5)>0|sa(6)<0|sa(7)>0|sa(8)<0|...
      sa(9)>0|sa(10)<0|sa(11)>0|sa(12)<0|sa(13)>0|sa(14)<0|sa(15)>0|...
      abs(sa(16))>0.00001
%while sa(1)>0|sa(2)<0|sa(3)>0|sa(4)<0

% Empty aues from the previous run    
aues_off = zeros(n,n);        

% For each row create random variables no larger than the |diagonal term|/n
for i = 1:n-3
    offi = (-1+2*rand)*abs(aues_diag(i,i))/n;
    for j = i+1:n-1
%        aues_off(i,j) = (-1+2*rand)*abs(aues_diag(i,i))/n;
         aues_off(i,j) = offi;
         aues_off(j,i) = aues_off(i,j);
    end
end

aues = aues_diag + aues_off;

% Create the "A" (LHS coefficient) matrix for solving the unknowns
A = zeros(n,n);
for i = 1:n-1
    A(i,i) = theta(n,1);
    A(n,i) = theta(i,1);
end
A(n-2,n) = theta(n-1,1);
A(n-1,n) = theta(n-2,1);

% This incomplete aues matrix is suitable for finding "C" (RHS coefficient) matrix 
C = -aues*theta;

% The unknowns are in "B" and are solved by A*B = C
B = inv(A)*C;

% Assign "B" to uknowns in aues, and now all aues unknows are found
for i = 1:n-1
    aues(i,n) = B(i,1);
end
aues(n-2,n-1) = B(n,1);

% Assign the solved AUES unknows (i,j) to their corresponding (j,i) elements 
for i = 1:n
    for j= 1:n
aues(j,i) = aues(i,j);
    end
end

% Check Cournot aggregation
cournot = aues*theta;

% Check NSD
for i = 1:n
sa(i) = det(aues(1:i, 1:i)/10);
end

end